/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.util.HomePosition;
import com.iafenvoy.iceandfire.item.block.BlockGoldPile;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.iafenvoy.uranus.util.ShapeBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3481;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public abstract class DragonCaveStructure
extends class_3195 {
    protected DragonCaveStructure(class_3195.class_7302 config) {
        super(config);
    }

    protected Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (context.comp_566().method_43058() >= this.getGenerateChance()) {
            return Optional.empty();
        }
        class_2470 blockRotation = class_2470.method_16548((class_5819)context.comp_566());
        class_2338 blockPos = this.method_42382(context, blockRotation);
        if (!GenerationConstants.isFarEnoughFromSpawn(blockPos)) {
            return Optional.empty();
        }
        return Optional.of(new class_3195.class_7150(blockPos, collector -> this.addPieces((class_6626)collector, blockPos, context, context.comp_566().method_43056())));
    }

    private void addPieces(class_6626 collector, class_2338 pos, class_3195.class_7149 context, boolean male) {
        int y = context.comp_569().method_31607() + 40 + context.comp_566().method_43048(30);
        long seed = context.comp_566().method_43055();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                collector.method_35462((class_3443)this.createPiece(new class_3341(pos.method_10263() + i * 32, y - 12, pos.method_10260() + j * 32, pos.method_10263() + i * 32, y + 12, pos.method_10260() + j * 32), male, new class_2338(i * 32, 0, j * 32), y, seed));
            }
        }
    }

    protected abstract DragonCavePiece createPiece(class_3341 var1, boolean var2, class_2338 var3, int var4, long var5);

    protected abstract double getGenerateChance();

    protected static abstract class DragonCavePiece
    extends class_3443 {
        private final boolean male;
        private final class_2338 offset;
        private final int y;
        private final long seed;

        protected DragonCavePiece(class_3773 type, int length, class_3341 boundingBox, boolean male, class_2338 offset, int y, long seed) {
            super(type, length, boundingBox);
            this.male = male;
            this.offset = offset;
            this.y = y;
            this.seed = seed;
        }

        public DragonCavePiece(class_3773 type, class_2487 nbt) {
            super(type, nbt);
            this.male = nbt.method_10577("male");
            this.offset = class_2338.method_10092((long)nbt.method_10537("offset"));
            this.y = nbt.method_10550("down");
            this.seed = nbt.method_10537("seed");
        }

        protected void method_14943(class_6625 context, class_2487 nbt) {
            nbt.method_10556("male", this.male);
            nbt.method_10544("offset", this.offset.method_10063());
            nbt.method_10569("down", this.y);
            nbt.method_10544("seed", this.seed);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            random = new class_5820(this.seed);
            class_2338 position = new class_2338((chunkPos.field_9181 << 4) + 8, this.y, (chunkPos.field_9180 << 4) + 8).method_10059((class_2382)this.offset);
            int dragonAge = 75 + random.method_43048(50);
            int radius = (int)((float)dragonAge * 0.2f) + random.method_43048(4);
            this.generateCave((class_1936)world, radius, 3, position, random);
            if (this.offset.equals((Object)new class_2338(0, 0, 0))) {
                EntityDragonBase dragon = this.createDragon(world, random, position, dragonAge);
                world.method_8649((class_1297)dragon);
            }
        }

        private boolean isOutOfRange(class_1923 chunkPos, class_2338 blockPos) {
            return chunkPos.method_8326() - 16 > blockPos.method_10263() || blockPos.method_10263() > chunkPos.method_8327() + 16 || chunkPos.method_8328() - 16 > blockPos.method_10260() || blockPos.method_10260() > chunkPos.method_8329() + 16;
        }

        public void generateCave(class_1936 worldIn, int radius, int amount, class_2338 center, class_5819 rand) {
            ArrayList<SphereInfo> sphereList = new ArrayList<SphereInfo>();
            sphereList.add(new SphereInfo(radius, center.method_10062()));
            Stream<class_2338> sphereBlocks = ShapeBuilder.start().getAllInCutOffSphereMutable(radius, radius / 2, center).toStream(false);
            Stream<class_2338> hollowBlocks = ShapeBuilder.start().getAllInRandomlyDistributedRangeYCutOffSphereMutable(radius - 2, (int)((double)(radius - 2) * 0.75), (radius - 2) / 2, rand, center).toStream(false);
            for (int i = 0; i < amount + rand.method_43048(2); ++i) {
                class_2350 direction = GenerationConstants.HORIZONTALS[rand.method_43048(GenerationConstants.HORIZONTALS.length - 1)];
                int r = 2 * (int)((float)radius / 3.0f) + rand.method_43048(8);
                class_2338 centerOffset = center.method_10079(direction, radius - 2);
                sphereBlocks = Stream.concat(sphereBlocks, ShapeBuilder.start().getAllInCutOffSphereMutable(r, r, centerOffset).toStream(false));
                hollowBlocks = Stream.concat(hollowBlocks, ShapeBuilder.start().getAllInRandomlyDistributedRangeYCutOffSphereMutable(r - 2, (int)((double)(r - 2) * 0.75), (r - 2) / 2, rand, centerOffset).toStream(false));
                sphereList.add(new SphereInfo(r, centerOffset));
            }
            Set<class_2338> shellBlocksSet = sphereBlocks.map(class_2338::method_10062).collect(Collectors.toSet());
            Set<class_2338> hollowBlocksSet = hollowBlocks.map(class_2338::method_10062).collect(Collectors.toSet());
            shellBlocksSet.removeAll(hollowBlocksSet);
            class_1923 chunkPos = new class_1923(center.method_10081((class_2382)this.offset));
            shellBlocksSet.removeIf(x -> this.isOutOfRange(chunkPos, (class_2338)x));
            hollowBlocksSet.removeIf(x -> this.isOutOfRange(chunkPos, (class_2338)x));
            this.createShell(worldIn, rand, shellBlocksSet);
            this.hollowOut(worldIn, hollowBlocksSet);
            this.decorateCave(worldIn, rand, hollowBlocksSet, sphereList, center);
            sphereList.clear();
        }

        public void createShell(class_1936 worldIn, class_5819 rand, Set<class_2338> positions) {
            List<class_2248> rareOres = this.getBlockList(IafBlockTags.DRAGON_CAVE_RARE_ORES);
            List<class_2248> uncommonOres = this.getBlockList(IafBlockTags.DRAGON_CAVE_UNCOMMON_ORES);
            List<class_2248> commonOres = this.getBlockList(IafBlockTags.DRAGON_CAVE_COMMON_ORES);
            List<class_2248> dragonTypeOres = this.getBlockList(this.getOreTag());
            positions.forEach(blockPos -> {
                if (!(worldIn.method_8320(blockPos).method_26204() instanceof class_2237) && worldIn.method_8320(blockPos).method_26214((class_1922)worldIn, blockPos) >= 0.0f) {
                    boolean doOres;
                    boolean bl = doOres = rand.method_43058() < (Double)IafCommonConfig.INSTANCE.dragon.generateOreRatio.getValue();
                    if (doOres) {
                        class_2248 toPlace = null;
                        if (rand.method_43056()) {
                            toPlace = !dragonTypeOres.isEmpty() ? (class_2248)dragonTypeOres.get(rand.method_43048(dragonTypeOres.size())) : null;
                        } else {
                            double chance = rand.method_43058();
                            if (!rareOres.isEmpty() && chance <= 0.15) {
                                toPlace = (class_2248)rareOres.get(rand.method_43048(rareOres.size()));
                            } else if (!uncommonOres.isEmpty() && chance <= 0.45) {
                                toPlace = (class_2248)uncommonOres.get(rand.method_43048(uncommonOres.size()));
                            } else if (!commonOres.isEmpty()) {
                                toPlace = (class_2248)commonOres.get(rand.method_43048(commonOres.size()));
                            }
                        }
                        if (toPlace != null) {
                            worldIn.method_8652(blockPos, toPlace.method_9564(), 2);
                        } else {
                            worldIn.method_8652(blockPos, this.getPaletteBlock(rand), 2);
                        }
                    } else {
                        worldIn.method_8652(blockPos, this.getPaletteBlock(rand), 2);
                    }
                }
            });
        }

        private List<class_2248> getBlockList(class_6862<class_2248> tagKey) {
            return class_7923.field_41175.method_40266(tagKey).map(holders -> holders.method_40239().map(class_6880::comp_349).toList()).orElse(Collections.emptyList());
        }

        public void hollowOut(class_1936 worldIn, Set<class_2338> positions) {
            positions.forEach(blockPos -> {
                if (!(worldIn.method_8320(blockPos).method_26204() instanceof class_2237)) {
                    worldIn.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
                }
            });
        }

        public void decorateCave(class_1936 worldIn, class_5819 rand, Set<class_2338> positions, List<SphereInfo> spheres, class_2338 center) {
            for (SphereInfo sphere : spheres) {
                class_2338 pos = sphere.pos();
                int radius = sphere.radius();
                for (int i = 0; i < 15 + rand.method_43048(10); ++i) {
                    this.getCeilingDecoration().generate(worldIn, rand, pos.method_10086(radius / 2 - 1).method_10069(rand.method_43048(radius) - radius / 2, 0, rand.method_43048(radius) - radius / 2));
                }
            }
            positions.forEach(blockPos -> {
                class_2680 stateBelow;
                if (blockPos.method_10264() < center.method_10264() && ((stateBelow = worldIn.method_8320(blockPos.method_10074())).method_26164(class_3481.field_25806) || stateBelow.method_26164(IafBlockTags.DRAGON_ENVIRONMENT_BLOCKS)) && worldIn.method_8320(blockPos).method_26215()) {
                    this.setGoldPile(worldIn, (class_2338)blockPos, rand);
                }
            });
        }

        public void setGoldPile(class_1936 world, class_2338 pos, class_5819 rand) {
            if (!(world.method_8320(pos).method_26204() instanceof class_2237)) {
                int chance = rand.method_43048(99) + 1;
                if (chance < 60) {
                    boolean generateGold = rand.method_43058() < (Double)IafCommonConfig.INSTANCE.dragon.generateDenGoldChance.getValue() * (double)(this.male ? 1 : 2);
                    world.method_8652(pos, generateGold ? (class_2680)this.getTreasurePile().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + rand.method_43048(7))) : class_2246.field_10124.method_9564(), 3);
                } else if (chance == 61) {
                    class_2586 blockEntity;
                    world.method_8652(pos, (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)GenerationConstants.HORIZONTALS[rand.method_43048(3)]), 2);
                    if (world.method_8320(pos).method_26204() instanceof class_2281 && (blockEntity = world.method_8321(pos)) instanceof class_2595) {
                        class_2595 chestBlockEntity = (class_2595)blockEntity;
                        chestBlockEntity.method_11285(this.getChestTable(this.male), rand.method_43055());
                    }
                }
            }
        }

        private EntityDragonBase createDragon(class_5281 worldGen, class_5819 random, class_2338 position, int dragonAge) {
            EntityDragonBase dragon = (EntityDragonBase)this.getDragonType().method_5883((class_1937)worldGen.method_8410());
            assert (dragon != null);
            dragon.setGender(this.male);
            dragon.growDragon(dragonAge);
            dragon.setAgingDisabled(true);
            dragon.method_6033(dragon.method_6063());
            List<DragonColor> colors = DragonColor.getColorsByType(DragonType.getTypeByEntityType(this.getDragonType()));
            dragon.setVariant(colors.get(random.method_43048(colors.size())).name());
            dragon.method_5641((double)position.method_10263() + 0.5, (double)position.method_10264() + 0.5, (double)position.method_10260() + 0.5, random.method_43057() * 360.0f, 0.0f);
            dragon.method_6179(true);
            dragon.homePos = new HomePosition(position, (class_1937)worldGen.method_8410());
            dragon.setHunger(50);
            return dragon;
        }

        protected abstract class_6862<class_2248> getOreTag();

        protected abstract WorldGenCaveStalactites getCeilingDecoration();

        protected abstract class_2680 getTreasurePile();

        protected abstract class_2680 getPaletteBlock(class_5819 var1);

        protected abstract class_2960 getChestTable(boolean var1);

        protected abstract class_1299<? extends EntityDragonBase> getDragonType();
    }

    protected static class WorldGenCaveStalactites {
        private final class_2248 block;
        private final int maxHeight;

        public WorldGenCaveStalactites(class_2248 block, int maxHeight) {
            this.block = block;
            this.maxHeight = maxHeight;
        }

        public void generate(class_1936 worldIn, class_5819 rand, class_2338 position) {
            int height = this.maxHeight + rand.method_43048(3);
            for (int i = 0; i < height; ++i) {
                if (i < height / 2) {
                    worldIn.method_8652(position.method_10087(i).method_10095(), this.block.method_9564(), 2);
                    worldIn.method_8652(position.method_10087(i).method_10078(), this.block.method_9564(), 2);
                    worldIn.method_8652(position.method_10087(i).method_10072(), this.block.method_9564(), 2);
                    worldIn.method_8652(position.method_10087(i).method_10067(), this.block.method_9564(), 2);
                }
                worldIn.method_8652(position.method_10087(i), this.block.method_9564(), 2);
            }
        }
    }

    public record SphereInfo(int radius, class_2338 pos) {
    }
}

